package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.RelationBillHead;
import com.xforceplus.eccpxdomain.service.IRelationBillHeadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-28
 */
@RestController
public class RelationBillHeadController {

  @Autowired
  private IRelationBillHeadService relationBillHeadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param relationBillHead ${table.comment}
   * @return
   */
  @GetMapping("/relationbillheads" )
  public XfR getRelationBillHeads(XfPage page, RelationBillHead relationBillHead) {
    return XfR.ok(relationBillHeadServiceImpl.page(page, Wrappers.query(relationBillHead)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/relationbillheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(relationBillHeadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param relationBillHead ${table.comment}
   * @return XfR
   */
  @PostMapping("/relationbillheads")
  public XfR save(@RequestBody RelationBillHead relationBillHead) {
     return XfR.ok(relationBillHeadServiceImpl.save(relationBillHead));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param relationBillHead ${table.comment}
   * @return XfR
   */
  @PutMapping("/relationbillheads/{id}")
  public XfR putUpdate(@RequestBody RelationBillHead relationBillHead,@PathVariable Long id) {
      relationBillHead.setId(id);
      return XfR.ok(relationBillHeadServiceImpl.updateById(relationBillHead));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param relationBillHead ${table.comment}
   * @return XfR
   */
  @PatchMapping("/relationbillheads/{id}")
  public XfR patchUpdate(@RequestBody RelationBillHead relationBillHead,@PathVariable Long id) {
      RelationBillHead uprelationBillHead = relationBillHeadServiceImpl.getById(id);
      if(uprelationBillHead != null){
        uprelationBillHead = ObjectCopyUtils.copyProperties(relationBillHead,uprelationBillHead,true);
      }
      return XfR.ok(relationBillHeadServiceImpl.updateById(uprelationBillHead));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/relationbillheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(relationBillHeadServiceImpl.removeById(id));
  }

  @PostMapping("/relationbillheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "relation_bill_head");
     params.put("request", condition);

     return XfR.ok(relationBillHeadServiceImpl.querys(params));
  }

}
