package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.BaodaoOrderBillLine;
import com.xforceplus.eccpxdomain.service.IBaodaoOrderBillLineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-02
 */
@RestController
public class BaodaoOrderBillLineController {

  @Autowired
  private IBaodaoOrderBillLineService baodaoOrderBillLineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param baodaoOrderBillLine ${table.comment}
   * @return
   */
  @GetMapping("/baodaoorderbilllines" )
  public XfR getBaodaoOrderBillLines(XfPage page, BaodaoOrderBillLine baodaoOrderBillLine) {
    return XfR.ok(baodaoOrderBillLineServiceImpl.page(page, Wrappers.query(baodaoOrderBillLine)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/baodaoorderbilllines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(baodaoOrderBillLineServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param baodaoOrderBillLine ${table.comment}
   * @return XfR
   */
  @PostMapping("/baodaoorderbilllines")
  public XfR save(@RequestBody BaodaoOrderBillLine baodaoOrderBillLine) {
     return XfR.ok(baodaoOrderBillLineServiceImpl.save(baodaoOrderBillLine));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param baodaoOrderBillLine ${table.comment}
   * @return XfR
   */
  @PutMapping("/baodaoorderbilllines/{id}")
  public XfR putUpdate(@RequestBody BaodaoOrderBillLine baodaoOrderBillLine,@PathVariable Long id) {
      baodaoOrderBillLine.setId(id);
      return XfR.ok(baodaoOrderBillLineServiceImpl.updateById(baodaoOrderBillLine));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param baodaoOrderBillLine ${table.comment}
   * @return XfR
   */
  @PatchMapping("/baodaoorderbilllines/{id}")
  public XfR patchUpdate(@RequestBody BaodaoOrderBillLine baodaoOrderBillLine,@PathVariable Long id) {
      BaodaoOrderBillLine upbaodaoOrderBillLine = baodaoOrderBillLineServiceImpl.getById(id);
      if(upbaodaoOrderBillLine != null){
        upbaodaoOrderBillLine = ObjectCopyUtils.copyProperties(baodaoOrderBillLine,upbaodaoOrderBillLine,true);
      }
      return XfR.ok(baodaoOrderBillLineServiceImpl.updateById(upbaodaoOrderBillLine));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/baodaoorderbilllines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(baodaoOrderBillLineServiceImpl.removeById(id));
  }

  @PostMapping("/baodaoorderbilllines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "baodao_order_bill_line");
     params.put("request", condition);

     return XfR.ok(baodaoOrderBillLineServiceImpl.querys(params));
  }

}
