package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.BaolongOrderBillhead;
import com.xforceplus.eccpxdomain.service.IBaolongOrderBillheadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-02
 */
@RestController
public class BaolongOrderBillheadController {

  @Autowired
  private IBaolongOrderBillheadService baolongOrderBillheadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param baolongOrderBillhead ${table.comment}
   * @return
   */
  @GetMapping("/baolongorderbillheads" )
  public XfR getBaolongOrderBillheads(XfPage page, BaolongOrderBillhead baolongOrderBillhead) {
    return XfR.ok(baolongOrderBillheadServiceImpl.page(page, Wrappers.query(baolongOrderBillhead)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/baolongorderbillheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(baolongOrderBillheadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param baolongOrderBillhead ${table.comment}
   * @return XfR
   */
  @PostMapping("/baolongorderbillheads")
  public XfR save(@RequestBody BaolongOrderBillhead baolongOrderBillhead) {
     return XfR.ok(baolongOrderBillheadServiceImpl.save(baolongOrderBillhead));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param baolongOrderBillhead ${table.comment}
   * @return XfR
   */
  @PutMapping("/baolongorderbillheads/{id}")
  public XfR putUpdate(@RequestBody BaolongOrderBillhead baolongOrderBillhead,@PathVariable Long id) {
      baolongOrderBillhead.setId(id);
      return XfR.ok(baolongOrderBillheadServiceImpl.updateById(baolongOrderBillhead));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param baolongOrderBillhead ${table.comment}
   * @return XfR
   */
  @PatchMapping("/baolongorderbillheads/{id}")
  public XfR patchUpdate(@RequestBody BaolongOrderBillhead baolongOrderBillhead,@PathVariable Long id) {
      BaolongOrderBillhead upbaolongOrderBillhead = baolongOrderBillheadServiceImpl.getById(id);
      if(upbaolongOrderBillhead != null){
        upbaolongOrderBillhead = ObjectCopyUtils.copyProperties(baolongOrderBillhead,upbaolongOrderBillhead,true);
      }
      return XfR.ok(baolongOrderBillheadServiceImpl.updateById(upbaolongOrderBillhead));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/baolongorderbillheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(baolongOrderBillheadServiceImpl.removeById(id));
  }

  @PostMapping("/baolongorderbillheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "baolong_order_billhead");
     params.put("request", condition);

     return XfR.ok(baolongOrderBillheadServiceImpl.querys(params));
  }

}
