package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.InvoiceBillHead;
import com.xforceplus.eccpxdomain.service.IInvoiceBillHeadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-02
 */
@RestController
public class InvoiceBillHeadController {

  @Autowired
  private IInvoiceBillHeadService invoiceBillHeadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceBillHead ${table.comment}
   * @return
   */
  @GetMapping("/invoicebillheads" )
  public XfR getInvoiceBillHeads(XfPage page, InvoiceBillHead invoiceBillHead) {
    return XfR.ok(invoiceBillHeadServiceImpl.page(page, Wrappers.query(invoiceBillHead)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicebillheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceBillHeadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceBillHead ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicebillheads")
  public XfR save(@RequestBody InvoiceBillHead invoiceBillHead) {
     return XfR.ok(invoiceBillHeadServiceImpl.save(invoiceBillHead));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceBillHead ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicebillheads/{id}")
  public XfR putUpdate(@RequestBody InvoiceBillHead invoiceBillHead,@PathVariable Long id) {
      invoiceBillHead.setId(id);
      return XfR.ok(invoiceBillHeadServiceImpl.updateById(invoiceBillHead));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceBillHead ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicebillheads/{id}")
  public XfR patchUpdate(@RequestBody InvoiceBillHead invoiceBillHead,@PathVariable Long id) {
      InvoiceBillHead upinvoiceBillHead = invoiceBillHeadServiceImpl.getById(id);
      if(upinvoiceBillHead != null){
        upinvoiceBillHead = ObjectCopyUtils.copyProperties(invoiceBillHead,upinvoiceBillHead,true);
      }
      return XfR.ok(invoiceBillHeadServiceImpl.updateById(upinvoiceBillHead));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicebillheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceBillHeadServiceImpl.removeById(id));
  }

  @PostMapping("/invoicebillheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_bill_head");
     params.put("request", condition);

     return XfR.ok(invoiceBillHeadServiceImpl.querys(params));
  }

}
