package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.PaymentBillLine;
import com.xforceplus.eccpxdomain.service.IPaymentBillLineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-02
 */
@RestController
public class PaymentBillLineController {

  @Autowired
  private IPaymentBillLineService paymentBillLineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param paymentBillLine ${table.comment}
   * @return
   */
  @GetMapping("/paymentbilllines" )
  public XfR getPaymentBillLines(XfPage page, PaymentBillLine paymentBillLine) {
    return XfR.ok(paymentBillLineServiceImpl.page(page, Wrappers.query(paymentBillLine)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/paymentbilllines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paymentBillLineServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param paymentBillLine ${table.comment}
   * @return XfR
   */
  @PostMapping("/paymentbilllines")
  public XfR save(@RequestBody PaymentBillLine paymentBillLine) {
     return XfR.ok(paymentBillLineServiceImpl.save(paymentBillLine));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param paymentBillLine ${table.comment}
   * @return XfR
   */
  @PutMapping("/paymentbilllines/{id}")
  public XfR putUpdate(@RequestBody PaymentBillLine paymentBillLine,@PathVariable Long id) {
      paymentBillLine.setId(id);
      return XfR.ok(paymentBillLineServiceImpl.updateById(paymentBillLine));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param paymentBillLine ${table.comment}
   * @return XfR
   */
  @PatchMapping("/paymentbilllines/{id}")
  public XfR patchUpdate(@RequestBody PaymentBillLine paymentBillLine,@PathVariable Long id) {
      PaymentBillLine uppaymentBillLine = paymentBillLineServiceImpl.getById(id);
      if(uppaymentBillLine != null){
        uppaymentBillLine = ObjectCopyUtils.copyProperties(paymentBillLine,uppaymentBillLine,true);
      }
      return XfR.ok(paymentBillLineServiceImpl.updateById(uppaymentBillLine));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paymentbilllines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paymentBillLineServiceImpl.removeById(id));
  }

  @PostMapping("/paymentbilllines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "payment_bill_line");
     params.put("request", condition);

     return XfR.ok(paymentBillLineServiceImpl.querys(params));
  }

}
