package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.PriceBillLine;
import com.xforceplus.eccpxdomain.service.IPriceBillLineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-02
 */
@RestController
public class PriceBillLineController {

  @Autowired
  private IPriceBillLineService priceBillLineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param priceBillLine ${table.comment}
   * @return
   */
  @GetMapping("/pricebilllines" )
  public XfR getPriceBillLines(XfPage page, PriceBillLine priceBillLine) {
    return XfR.ok(priceBillLineServiceImpl.page(page, Wrappers.query(priceBillLine)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pricebilllines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(priceBillLineServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param priceBillLine ${table.comment}
   * @return XfR
   */
  @PostMapping("/pricebilllines")
  public XfR save(@RequestBody PriceBillLine priceBillLine) {
     return XfR.ok(priceBillLineServiceImpl.save(priceBillLine));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param priceBillLine ${table.comment}
   * @return XfR
   */
  @PutMapping("/pricebilllines/{id}")
  public XfR putUpdate(@RequestBody PriceBillLine priceBillLine,@PathVariable Long id) {
      priceBillLine.setId(id);
      return XfR.ok(priceBillLineServiceImpl.updateById(priceBillLine));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param priceBillLine ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pricebilllines/{id}")
  public XfR patchUpdate(@RequestBody PriceBillLine priceBillLine,@PathVariable Long id) {
      PriceBillLine uppriceBillLine = priceBillLineServiceImpl.getById(id);
      if(uppriceBillLine != null){
        uppriceBillLine = ObjectCopyUtils.copyProperties(priceBillLine,uppriceBillLine,true);
      }
      return XfR.ok(priceBillLineServiceImpl.updateById(uppriceBillLine));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pricebilllines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(priceBillLineServiceImpl.removeById(id));
  }

  @PostMapping("/pricebilllines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "price_bill_line");
     params.put("request", condition);

     return XfR.ok(priceBillLineServiceImpl.querys(params));
  }

}
