package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.BillStatus;
import com.xforceplus.eccpxdomain.service.IBillStatusService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class BillStatusController {

  @Autowired
  private IBillStatusService billStatusServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billStatus ${table.comment}
   * @return
   */
  @GetMapping("/billstatuss" )
  public XfR getBillStatuss(XfPage page, BillStatus billStatus) {
    return XfR.ok(billStatusServiceImpl.page(page, Wrappers.query(billStatus)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billstatuss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billStatusServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billStatus ${table.comment}
   * @return XfR
   */
  @PostMapping("/billstatuss")
  public XfR save(@RequestBody BillStatus billStatus) {
     return XfR.ok(billStatusServiceImpl.save(billStatus));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billStatus ${table.comment}
   * @return XfR
   */
  @PutMapping("/billstatuss/{id}")
  public XfR putUpdate(@RequestBody BillStatus billStatus,@PathVariable Long id) {
      billStatus.setId(id);
      return XfR.ok(billStatusServiceImpl.updateById(billStatus));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billStatus ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billstatuss/{id}")
  public XfR patchUpdate(@RequestBody BillStatus billStatus,@PathVariable Long id) {
      BillStatus upbillStatus = billStatusServiceImpl.getById(id);
      if(upbillStatus != null){
        upbillStatus = ObjectCopyUtils.copyProperties(billStatus,upbillStatus,true);
      }
      return XfR.ok(billStatusServiceImpl.updateById(upbillStatus));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billstatuss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billStatusServiceImpl.removeById(id));
  }

  @PostMapping("/billstatuss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_status");
     params.put("request", condition);

     return XfR.ok(billStatusServiceImpl.querys(params));
  }

}
