package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.DeliverBillHead;
import com.xforceplus.eccpxdomain.service.IDeliverBillHeadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class DeliverBillHeadController {

  @Autowired
  private IDeliverBillHeadService deliverBillHeadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deliverBillHead ${table.comment}
   * @return
   */
  @GetMapping("/deliverbillheads" )
  public XfR getDeliverBillHeads(XfPage page, DeliverBillHead deliverBillHead) {
    return XfR.ok(deliverBillHeadServiceImpl.page(page, Wrappers.query(deliverBillHead)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/deliverbillheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deliverBillHeadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param deliverBillHead ${table.comment}
   * @return XfR
   */
  @PostMapping("/deliverbillheads")
  public XfR save(@RequestBody DeliverBillHead deliverBillHead) {
     return XfR.ok(deliverBillHeadServiceImpl.save(deliverBillHead));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param deliverBillHead ${table.comment}
   * @return XfR
   */
  @PutMapping("/deliverbillheads/{id}")
  public XfR putUpdate(@RequestBody DeliverBillHead deliverBillHead,@PathVariable Long id) {
      deliverBillHead.setId(id);
      return XfR.ok(deliverBillHeadServiceImpl.updateById(deliverBillHead));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param deliverBillHead ${table.comment}
   * @return XfR
   */
  @PatchMapping("/deliverbillheads/{id}")
  public XfR patchUpdate(@RequestBody DeliverBillHead deliverBillHead,@PathVariable Long id) {
      DeliverBillHead updeliverBillHead = deliverBillHeadServiceImpl.getById(id);
      if(updeliverBillHead != null){
        updeliverBillHead = ObjectCopyUtils.copyProperties(deliverBillHead,updeliverBillHead,true);
      }
      return XfR.ok(deliverBillHeadServiceImpl.updateById(updeliverBillHead));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deliverbillheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deliverBillHeadServiceImpl.removeById(id));
  }

  @PostMapping("/deliverbillheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "deliver_bill_head");
     params.put("request", condition);

     return XfR.ok(deliverBillHeadServiceImpl.querys(params));
  }

}
