package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.InvoiceBillLine;
import com.xforceplus.eccpxdomain.service.IInvoiceBillLineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class InvoiceBillLineController {

  @Autowired
  private IInvoiceBillLineService invoiceBillLineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceBillLine ${table.comment}
   * @return
   */
  @GetMapping("/invoicebilllines" )
  public XfR getInvoiceBillLines(XfPage page, InvoiceBillLine invoiceBillLine) {
    return XfR.ok(invoiceBillLineServiceImpl.page(page, Wrappers.query(invoiceBillLine)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicebilllines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceBillLineServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceBillLine ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicebilllines")
  public XfR save(@RequestBody InvoiceBillLine invoiceBillLine) {
     return XfR.ok(invoiceBillLineServiceImpl.save(invoiceBillLine));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceBillLine ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicebilllines/{id}")
  public XfR putUpdate(@RequestBody InvoiceBillLine invoiceBillLine,@PathVariable Long id) {
      invoiceBillLine.setId(id);
      return XfR.ok(invoiceBillLineServiceImpl.updateById(invoiceBillLine));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceBillLine ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicebilllines/{id}")
  public XfR patchUpdate(@RequestBody InvoiceBillLine invoiceBillLine,@PathVariable Long id) {
      InvoiceBillLine upinvoiceBillLine = invoiceBillLineServiceImpl.getById(id);
      if(upinvoiceBillLine != null){
        upinvoiceBillLine = ObjectCopyUtils.copyProperties(invoiceBillLine,upinvoiceBillLine,true);
      }
      return XfR.ok(invoiceBillLineServiceImpl.updateById(upinvoiceBillLine));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicebilllines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceBillLineServiceImpl.removeById(id));
  }

  @PostMapping("/invoicebilllines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_bill_line");
     params.put("request", condition);

     return XfR.ok(invoiceBillLineServiceImpl.querys(params));
  }

}
