package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.PaymentBillHead;
import com.xforceplus.eccpxdomain.service.IPaymentBillHeadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class PaymentBillHeadController {

  @Autowired
  private IPaymentBillHeadService paymentBillHeadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param paymentBillHead ${table.comment}
   * @return
   */
  @GetMapping("/paymentbillheads" )
  public XfR getPaymentBillHeads(XfPage page, PaymentBillHead paymentBillHead) {
    return XfR.ok(paymentBillHeadServiceImpl.page(page, Wrappers.query(paymentBillHead)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/paymentbillheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paymentBillHeadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param paymentBillHead ${table.comment}
   * @return XfR
   */
  @PostMapping("/paymentbillheads")
  public XfR save(@RequestBody PaymentBillHead paymentBillHead) {
     return XfR.ok(paymentBillHeadServiceImpl.save(paymentBillHead));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param paymentBillHead ${table.comment}
   * @return XfR
   */
  @PutMapping("/paymentbillheads/{id}")
  public XfR putUpdate(@RequestBody PaymentBillHead paymentBillHead,@PathVariable Long id) {
      paymentBillHead.setId(id);
      return XfR.ok(paymentBillHeadServiceImpl.updateById(paymentBillHead));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param paymentBillHead ${table.comment}
   * @return XfR
   */
  @PatchMapping("/paymentbillheads/{id}")
  public XfR patchUpdate(@RequestBody PaymentBillHead paymentBillHead,@PathVariable Long id) {
      PaymentBillHead uppaymentBillHead = paymentBillHeadServiceImpl.getById(id);
      if(uppaymentBillHead != null){
        uppaymentBillHead = ObjectCopyUtils.copyProperties(paymentBillHead,uppaymentBillHead,true);
      }
      return XfR.ok(paymentBillHeadServiceImpl.updateById(uppaymentBillHead));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paymentbillheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paymentBillHeadServiceImpl.removeById(id));
  }

  @PostMapping("/paymentbillheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "payment_bill_head");
     params.put("request", condition);

     return XfR.ok(paymentBillHeadServiceImpl.querys(params));
  }

}
