package com.xforceplus.eccpxdomainpoc.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据类型
 * </p>
 *
 * @author ultraman
 * @since 2020-12-15
 */
public enum BillType {

    ODRTF("ODRTF", "转换订单"),
    RET("RET", "退货单"),
    DLV("DLV", "送货单"),
    REC("REC", "验收单"),
    STM("STM", "结算单"),
    IVC("IVC", "发票"),
    PAM("PAM", "付款"),
    CTC("CTC", "合同"),
    PO("PO", "采购订单"),
    SO("SO", "销售订单"),
    CTAP("CTAP", "费用应付单"),
    CTAR("CTAR", "费用应收单"),
    CTDIF("CTDIF", "费用差异单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
