package com.xforceplus.eccpxdomainpoc.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2020-12-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderHeads implements Serializable {

  private static final long serialVersionUID=1L;

  private String purCompanyName;

  private String orderType;

  private String orderTypeName;

  private String orderNo;

  private Long aOrgId;

  private Long aOrgPersonId;

  private Long aLocalOrgId;

  private Long aLocalOrgPersonId;

  private Long bOrgId;

  private Long bOrgPersonId;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderDate;

  private String orderCode;

  private String orderAddress;

  private String isDeliver;

  private String deliverGroupNo;

  private String invNo;

  private String isInv;

  private String invGroupNo;

  private String isPayment;

  private String paymentGroupNo;

  private String calculationRule;

  private String calculationGroupNo;

  private BigDecimal amountWithoutTax;

  private BigDecimal taxAmount;

  private BigDecimal amountWithTax;

  private String correlationGroupNo;

  private Long investorOrgId;

  private Long executOrgId;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime planActivityDate;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualActivityDate;

  private BigDecimal expectAmount;

  private BigDecimal actualAmount;

  private String activitySettlementName;

  private String shopNo;

  private String shopName;

  private String shopPhone;

  private String shopAddress;

  private Long purchaserId;

  private String purchaserName;

  private String purchaserPhone;

  private String supplierNo;

  private String supplierName;

  private String supplierAddress;

  private Long sellerId;

  private String sellerName;

  private String sellerPhone;

  private String erpOrderStatus;

  private String confirmStatus;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime supplierConfirmDate;

  private String invoiceStatus;

  private String isTimeoutDeliver;

  private String deleteBy;

  private Long parentVersion;

  private Long version;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deleteTime;

  private String remark;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




}
