package com.xforceplus.eccpxdomainpoc.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2020-12-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderLineDelivers implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("orderId")
  private Long orderId;

  @TableField("deliverId")
  private Long deliverId;

  @TableField("lineNo")
  private String lineNo;

  @TableField("headDeliverLineNo")
  private String headDeliverLineNo;

  @TableField("receiveOrgId")
  private Long receiveOrgId;

  @TableField("deliverOrgId")
  private Long deliverOrgId;

  @TableField("deliverStatus")
  private String deliverStatus;

  @TableField("planDeliverDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime planDeliverDate;

  @TableField("actualDeliverDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualDeliverDate;

  @TableField("deliveryModeId")
  private Long deliveryModeId;

  private Long quantity;

  @TableField("quantityUnit")
  private String quantityUnit;

  @TableField("deleteBy")
  private String deleteBy;

  @TableField("deleteTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deleteTime;

  private Long version;

  @TableField("parentVersion")
  private Long parentVersion;

  private String remark;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("lineDeliverLineNo")
  private String lineDeliverLineNo;




}
