package com.xforceplus.eccpxdomainpoc.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2020-12-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderLineSources implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("orderId")
  private Long orderId;

  @TableField("skuId")
  private Long skuId;

  @TableField("skuSode")
  private String skuSode;

  @TableField("skuName")
  private String skuName;

  @TableField("lineNo")
  private String lineNo;

  @TableField("preLineNo")
  private String preLineNo;

  @TableField("preType")
  private String preType;

  @TableField("preTypeName")
  private String preTypeName;

  @TableField("preNo")
  private String preNo;

  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  @TableField("taxRate")
  private BigDecimal taxRate;

  @TableField("taxAmount")
  private BigDecimal taxAmount;

  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  @TableField("unitPrice")
  private BigDecimal unitPrice;

  private BigDecimal quantity;

  @TableField("quantityUnit")
  private String quantityUnit;

  @TableField("preDeliverLineNo")
  private String preDeliverLineNo;

  @TableField("preInvoiceLineNo")
  private String preInvoiceLineNo;

  @TableField("prePaymentLineNo")
  private String prePaymentLineNo;

  @TableField("deleteBy")
  private String deleteBy;

  @TableField("deleteTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deleteTime;

  private Long version;

  @TableField("parentVersion")
  private Long parentVersion;

  private String remark;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




}
