package com.xforceplus.eccpxdomainpoc.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2020-12-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderLines implements Serializable {

  private static final long serialVersionUID=1L;

  private Long orderId;

  private String orderNo;

  private String lineNo;

  private String lineType;

  private String lineTypeName;

  private Long skuId;

  private BigDecimal quantity;

  private String quantityUnit;

  private BigDecimal unitPrice;

  private BigDecimal amountWithoutTax;

  private BigDecimal taxAmount;

  private BigDecimal taxRate;

  private BigDecimal amountWithTax;

  private String lineStatus;

  private String sourceGroupNo;

  private String deliverGroupNo;

  private String invoiceGroupNo;

  private String paymentGroupNo;

  private String priceCalculateRule;

  private String calculationGroupNo;

  private String correlationGroupNo;

  private String sourceType;

  private String letOut;

  private String activityCostType;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime planActivityDate;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualActivityDate;

  private BigDecimal companyBudgetAmount;

  private Long planActivityCount;

  private Long actualActivityCount;

  private BigDecimal budgetAmount;

  private BigDecimal actualAmount;

  private Long activityDetailId;

  private String activitySettlementName;

  private String deleteBy;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deleteTime;

  private Long version;

  private Long parentVersion;

  private String remark;

  private String goodCode;

  private String goodSn;

  private String goodName;

  private String goodSpecs;

  private String goodUnit;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




}
