package com.xforceplus.eccpxdomainpoc.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.baomidou.mybatisplus.annotation.TableName;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2020-12-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("order_heads")
public class PayableOrder implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("purCompanyName")
  private String purCompanyName;

  @TableField("orderType")
  private String orderType;

  @TableField("orderTypeName")
  private String orderTypeName;

  @TableField("orderNo")
  private String orderNo;

  @TableField("firstOrgId")
  private Long firstOrgId;

  @TableField("firstOrgPersonId")
  private Long firstOrgPersonId;

  @TableField("firstLocalOrgId")
  private Long firstLocalOrgId;

  @TableField("firstLocalOrgPersonId")
  private Long firstLocalOrgPersonId;

  @TableField("secondOrgId")
  private Long secondOrgId;

  @TableField("secondOrgPersonId")
  private Long secondOrgPersonId;

  @TableField("orderDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderDate;

  @TableField("orderCode")
  private String orderCode;

  @TableField("orderAddress")
  private String orderAddress;

  @TableField("isDeliver")
  private String isDeliver;

  @TableField("deliverGroupNo")
  private String deliverGroupNo;

  @TableField("invNo")
  private String invNo;

  @TableField("isInv")
  private String isInv;

  @TableField("invGroupNo")
  private String invGroupNo;

  @TableField("isPayment")
  private String isPayment;

  @TableField("paymentGroupNo")
  private String paymentGroupNo;

  @TableField("calculationRule")
  private String calculationRule;

  @TableField("calculationGroupNo")
  private String calculationGroupNo;

  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  @TableField("taxAmount")
  private BigDecimal taxAmount;

  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  @TableField("correlationGroupNo")
  private String correlationGroupNo;

  @TableField("investorOrgId")
  private Long investorOrgId;

  @TableField("executOrgId")
  private Long executOrgId;

  @TableField("planActivityDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime planActivityDate;

  @TableField("actualActivityDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualActivityDate;

  @TableField("expectAmount")
  private BigDecimal expectAmount;

  @TableField("actualAmount")
  private BigDecimal actualAmount;

  @TableField("activitySettlementName")
  private String activitySettlementName;

  @TableField("shopNo")
  private String shopNo;

  @TableField("shopName")
  private String shopName;

  @TableField("shopPhone")
  private String shopPhone;

  @TableField("shopAddress")
  private String shopAddress;

  @TableField("purchaserId")
  private Long purchaserId;

  @TableField("purchaserName")
  private String purchaserName;

  @TableField("purchaserPhone")
  private String purchaserPhone;

  @TableField("supplierNo")
  private String supplierNo;

  @TableField("supplierName")
  private String supplierName;

  @TableField("supplierAddress")
  private String supplierAddress;

  @TableField("sellerId")
  private Long sellerId;

  @TableField("sellerName")
  private String sellerName;

  @TableField("sellerPhone")
  private String sellerPhone;

  @TableField("erpOrderStatus")
  private String erpOrderStatus;

  @TableField("confirmStatus")
  private String confirmStatus;

  @TableField("supplierConfirmDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime supplierConfirmDate;

  @TableField("invoiceStatus")
  private String invoiceStatus;

  @TableField("isTimeoutDeliver")
  private String isTimeoutDeliver;

  @TableField("deleteBy")
  private String deleteBy;

  @TableField("parentVersion")
  private Long parentVersion;

  private Long version;

  @TableField("deleteTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deleteTime;

  private String remark;

  @TableField("deliverStatus")
  private String deliverStatus;

  @TableField("planDeliverDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime planDeliverDate;

  @TableField("actualDeliverDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualDeliverDate;

  @TableField("duringDate")
  private String duringDate;

  @TableField("planActivityEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime planActivityEndDate;

  @TableField("actualActivityEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualActivityEndDate;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




}
