package com.xforceplus.eccpxdomainpoc.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2020-12-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PaymentOrderDetail implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("orderId")
  private Long orderId;

  @TableField("orderNo")
  private String orderNo;

  @TableField("lineNo")
  private String lineNo;

  @TableField("lineType")
  private String lineType;

  @TableField("lineTypeName")
  private String lineTypeName;

  @TableField("skuId")
  private Long skuId;

  private BigDecimal quantity;

  @TableField("quantityUnit")
  private String quantityUnit;

  @TableField("unitPrice")
  private BigDecimal unitPrice;

  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  @TableField("taxAmount")
  private BigDecimal taxAmount;

  @TableField("taxRate")
  private BigDecimal taxRate;

  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  @TableField("lineStatus")
  private String lineStatus;

  @TableField("sourceGroupNo")
  private String sourceGroupNo;

  @TableField("deliverGroupNo")
  private String deliverGroupNo;

  @TableField("invoiceGroupNo")
  private String invoiceGroupNo;

  @TableField("paymentGroupNo")
  private String paymentGroupNo;

  @TableField("priceCalculateRule")
  private String priceCalculateRule;

  @TableField("calculationGroupNo")
  private String calculationGroupNo;

  @TableField("correlationGroupNo")
  private String correlationGroupNo;

  @TableField("sourceType")
  private String sourceType;

  @TableField("letOut")
  private String letOut;

  @TableField("activityCostType")
  private String activityCostType;

  @TableField("planActivityDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime planActivityDate;

  @TableField("actualActivityDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualActivityDate;

  @TableField("companyBudgetAmount")
  private BigDecimal companyBudgetAmount;

  @TableField("planActivityCount")
  private Long planActivityCount;

  @TableField("actualActivityCount")
  private Long actualActivityCount;

  @TableField("budgetAmount")
  private BigDecimal budgetAmount;

  @TableField("actualAmount")
  private BigDecimal actualAmount;

  @TableField("activityDetailId")
  private Long activityDetailId;

  @TableField("activitySettlementName")
  private String activitySettlementName;

  @TableField("deleteBy")
  private String deleteBy;

  @TableField("deleteTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deleteTime;

  private Long version;

  @TableField("parentVersion")
  private Long parentVersion;

  private String remark;

  @TableField("goodCode")
  private String goodCode;

  @TableField("goodSn")
  private String goodSn;

  @TableField("goodName")
  private String goodName;

  @TableField("goodSpecs")
  private String goodSpecs;

  @TableField("goodUnit")
  private String goodUnit;

  @TableField("goodPackageSpecs")
  private String goodPackageSpecs;

  @TableField("categoryCode")
  private String categoryCode;

  @TableField("categoryName")
  private String categoryName;

  @TableField("shopName")
  private String shopName;

  @TableField("shopNo")
  private String shopNo;

  @TableField("shopAddress")
  private String shopAddress;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




}
