/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccp.common.stub;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.eccp.common.stub.CommonErrorEnum;
import com.xforceplus.eccp.common.stub.ErrorEnum;
import java.io.Serializable;
import java.util.List;

public class CommonPageResult<T>
implements Serializable {
    private String code;
    @JsonProperty(value="message")
    private String msg;
    @JsonProperty(value="result")
    private PageData data;
    private boolean success;

    private void setResult(ErrorEnum errorEnum) {
        this.setCode(errorEnum.getCode());
        this.setMsg(errorEnum.getMsg());
        this.setSuccess(errorEnum.getCode() == CommonErrorEnum.Success.getCode());
    }

    public static <T> CommonPageResult buildSuccess(List<T> records, int pageNo, int pageSize, long total) {
        CommonPageResult<T> result = new CommonPageResult<T>();
        PageData<T> pageData = new PageData<T>();
        pageData.setRecords(records);
        pageData.setCurrent(pageNo);
        pageData.setSize(pageSize);
        pageData.setTotal(total);
        result.setData(pageData);
        super.setResult(CommonErrorEnum.Success);
        return result;
    }

    public static <T> CommonPageResult buildError(String code, String msg) {
        CommonPageResult<T> result = new CommonPageResult<T>();
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    public static <T> CommonPageResult buildError(ErrorEnum errorEnum) {
        return CommonPageResult.buildError(errorEnum.getCode(), errorEnum.getMsg());
    }

    public static <T> CommonPageResult buildErrorWithMsg(ErrorEnum errorEnum, String msg) {
        CommonPageResult result = CommonPageResult.buildError(errorEnum);
        result.setMsg(msg);
        return result;
    }

    public static <T> CommonPageResult buildErrorAppendMsg(ErrorEnum errorEnum, String msg) {
        CommonPageResult result = CommonPageResult.buildError(errorEnum);
        result.setMsg(errorEnum.getMsg() + msg);
        return result;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public PageData getData() {
        return this.data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @JsonProperty(value="message")
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @JsonProperty(value="result")
    public void setData(PageData data) {
        this.data = data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonPageResult)) {
            return false;
        }
        CommonPageResult other = (CommonPageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        PageData this$data = this.getData();
        PageData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        return this.isSuccess() == other.isSuccess();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonPageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        PageData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CommonPageResult(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", success=" + this.isSuccess() + ")";
    }

    public static class PageData<T>
    implements Serializable {
        private List<T> records;
        private long total;
        @JsonProperty(value="pageSize")
        private long size;
        private long current;

        public List<T> getRecords() {
            return this.records;
        }

        public long getTotal() {
            return this.total;
        }

        public long getSize() {
            return this.size;
        }

        public long getCurrent() {
            return this.current;
        }

        public void setRecords(List<T> records) {
            this.records = records;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        @JsonProperty(value="pageSize")
        public void setSize(long size) {
            this.size = size;
        }

        public void setCurrent(long current) {
            this.current = current;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PageData)) {
                return false;
            }
            PageData other = (PageData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<T> this$records = this.getRecords();
            List<T> other$records = other.getRecords();
            if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            return this.getCurrent() == other.getCurrent();
        }

        protected boolean canEqual(Object other) {
            return other instanceof PageData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<T> $records = this.getRecords();
            result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
            long $total = this.getTotal();
            result = result * 59 + (int)($total >>> 32 ^ $total);
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            long $current = this.getCurrent();
            result = result * 59 + (int)($current >>> 32 ^ $current);
            return result;
        }

        public String toString() {
            return "CommonPageResult.PageData(records=" + this.getRecords() + ", total=" + this.getTotal() + ", size=" + this.getSize() + ", current=" + this.getCurrent() + ")";
        }
    }
}

