/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccp.common.stub;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.eccp.common.stub.CommonErrorEnum;
import com.xforceplus.eccp.common.stub.ErrorEnum;
import java.io.Serializable;

public class CommonResult<T>
implements Serializable {
    private String code;
    @JsonProperty(value="message")
    private String msg;
    @JsonProperty(value="result")
    private T data;
    private boolean success;

    private void setResult(CommonErrorEnum errorEnum) {
        this.setCode(errorEnum.getCode());
        this.setMsg(errorEnum.getMsg());
        this.setSuccess(errorEnum.getCode() == CommonErrorEnum.Success.getCode());
    }

    public static <T> CommonResult buildSuccess() {
        CommonResult<T> result = new CommonResult<T>();
        super.setResult(CommonErrorEnum.Success);
        return result;
    }

    public static <T> CommonResult buildSuccess(T t) {
        CommonResult<T> result = new CommonResult<T>();
        result.setData(t);
        super.setResult(CommonErrorEnum.Success);
        return result;
    }

    public static <T> CommonResult buildError(String code, String msg) {
        CommonResult<T> result = new CommonResult<T>();
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    public static <T> CommonResult buildError(ErrorEnum errorEnum) {
        return CommonResult.buildError(errorEnum.getCode(), errorEnum.getMsg());
    }

    public static <T> CommonResult buildErrorWithMsg(ErrorEnum errorEnum, String msg) {
        CommonResult result = CommonResult.buildError(errorEnum);
        result.setMsg(msg);
        return result;
    }

    public static <T> CommonResult buildErrorAppendMsg(ErrorEnum errorEnum, String msg) {
        CommonResult result = CommonResult.buildError(errorEnum);
        result.setMsg(errorEnum.getMsg() + msg);
        return result;
    }

    public static <T> CommonResult buildError(ErrorEnum errorEnum, T t) {
        CommonResult result = CommonResult.buildError(errorEnum);
        result.setData(t);
        return result;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @JsonProperty(value="message")
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @JsonProperty(value="result")
    public void setData(T data) {
        this.data = data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonResult)) {
            return false;
        }
        CommonResult other = (CommonResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        return this.isSuccess() == other.isSuccess();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CommonResult(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", success=" + this.isSuccess() + ")";
    }
}

