package com.xforceplus.tower.econtract.api;

import com.xforceplus.tower.econtract.model.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

import java.util.List;

import static org.springframework.http.MediaType.APPLICATION_JSON_UTF8_VALUE;

@RequestMapping("/{tenantId}/enterprise/v1/econtract")
@Api(tags = "electronic contract")
public interface ContractApi {

    @RequestMapping(value = "/contracts/templates", method = RequestMethod.POST, produces = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "上传合同模板")
    DefaultResponse uploadTemplate(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = false) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "合同模板文件", required = true) @RequestParam("multipartFile") MultipartFile multipartFile);


    @RequestMapping(value = "/contracts", method = RequestMethod.POST, produces = APPLICATION_JSON_UTF8_VALUE, consumes = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "创建合同")
    DefaultResponse createContract(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = false) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "创建合同请求", required = true) @RequestBody @Valid ContractCreationRequest contractCreationRequest);

    @RequestMapping(value = "/contracts/{contractId}/signature", method = RequestMethod.POST, produces = APPLICATION_JSON_UTF8_VALUE, consumes = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "签署合同")
    DefaultResponse signContract(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "合同id", required = true) @PathVariable("contractId") String contractId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = true) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "是否自动签署", required = true) @RequestParam("auto") Boolean auto,
            @ApiParam(value = "签署合同请求", required = true) @RequestBody @Valid ContractSignRequest contractSignRequest);

    @RequestMapping(value = "/contracts/{contractId}", method = RequestMethod.GET, produces = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "获取合同")
    DefaultResponse obtainContract(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "合同id", required = true) @PathVariable("contractId") String contractId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = true) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "是否需要下载", required = true) @RequestParam("download") Boolean download);

    @RequestMapping(value = "/contracts", method = RequestMethod.GET, produces = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查询签署合同")
    DefaultResponse  fetchContract(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司税号", required = true) @RequestParam("taxNo") List<String> taxNo,
            @ApiParam(value = "合同状态（0:未签署,1:已签署）", required = false) @RequestParam(value = "signStatus",required = false) Integer signStatus,
            @RequestParam(value = "pageNo", required = false) @Min(1) Integer page,
            @RequestParam(value = "pageSize", required = false) @Min(1) @Max(200) Integer size
            );

    @RequestMapping(value = "/contracts/signature", method = RequestMethod.POST, produces = APPLICATION_JSON_UTF8_VALUE,
            consumes = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "签署合同")
    DefaultResponse signedContract(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = false) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "签署合同请求", required = true) @RequestBody @Valid ContractSignRequest contractSignRequest);


    @RequestMapping(value = "/contracts/import", method = RequestMethod.POST, produces = APPLICATION_JSON_UTF8_VALUE )
    @ApiOperation(value = "上传待签署合同")
    DefaultResponse importContract(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = false) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "合同模板Code", required = true) @RequestParam("contractTemplateCode") String contractTemplateCode,
            @RequestParam(value = "上传文件", required = true) MultipartFile multipartFile);




    @RequestMapping(value = "/management/contracts", method = RequestMethod.GET, produces = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查询合同签署结果")
    DefaultResponse  queryContract(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司名称", required = false) @RequestParam("companyName") String companyName,
            @ApiParam(value = "公司税号", required = false) @RequestParam("taxNo") String taxNo,
            @ApiParam(value = "合同状态（0:未签署,1:已签署）", required = false) @RequestParam(value = "signStatus",required = false) Integer signStatus,
            @RequestParam(value = "pageNo", required = false) @Min(1) Integer page,
            @RequestParam(value = "pageSize", required = false) @Min(1) @Max(200) Integer size
    );


    @RequestMapping(value = "/management/contracts/status", method = RequestMethod.PUT, produces = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "更改签署状态")
    DefaultResponse  updateContractStatus(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司税号", required = true) @RequestParam("taxNo") List<String> taxNo,
            @ApiParam(value = "合同状态（0:未签署,1:已签署, 2:无需签署）", required = true) @RequestParam(value = "signStatus",required = true) Integer signStatus
    );

}
