package com.xforceplus.tower.econtract.api;

import com.xforceplus.tower.econtract.model.DefaultResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import static org.springframework.http.MediaType.APPLICATION_JSON_UTF8_VALUE;

/**
 * @author lixuekun
 */
@RequestMapping("/{tenantId}/enterprise/v1/econtract")
@Api(tags = "合同模板")
public interface ContractTemplateApi {

    @RequestMapping(value = "/template", method = RequestMethod.POST, produces = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "新建合同模板")
    DefaultResponse uploadTemplate(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = true) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "合同模板文件", required = true) @RequestParam("multipartFile") MultipartFile multipartFile);
}
