package com.xforceplus.tower.econtract.api;

import com.xforceplus.tower.econtract.model.DefaultResponse;
import com.xforceplus.tower.econtract.model.TenantConfigRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

import static org.springframework.http.MediaType.APPLICATION_JSON_UTF8_VALUE;

@RequestMapping("/{tenantId}/enterprise/v1/econtract")
@Api(tags = "tenant conf")
public interface TenantConfigApi {

    @RequestMapping(value = "/tenant-conf", method = RequestMethod.POST, produces = APPLICATION_JSON_UTF8_VALUE, consumes = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "新增租户配置")
    DefaultResponse createTenantConfig(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = true) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "租户配置请求", required = true) @RequestBody @Valid TenantConfigRequest tenantConfigRequest);

    @RequestMapping(value = "/tenant-conf", method = RequestMethod.GET, produces = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "读取租户配置")
    DefaultResponse readTenantConfig(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = true) @RequestParam("companyId") Long companyId);

    @RequestMapping(value = "/tenant-conf", method = RequestMethod.PUT, produces = APPLICATION_JSON_UTF8_VALUE, consumes = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "更新租户配置")
    DefaultResponse updateTenantConfig(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = true) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "租户配置请求", required = true) @RequestBody @Valid TenantConfigRequest tenantConfigRequest);

    @RequestMapping(value = "/tenant-conf", method = RequestMethod.DELETE, produces = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "删除租户配置")
    DefaultResponse deleteTenantConfig(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = true) @RequestParam("companyId") Long companyId);

}
