package com.xforceplus.tower.econtract.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ContractCreationRequest implements Serializable {

    @ApiModelProperty(value = "公司名称", dataType = "String", name = "companyName", example = "上海万科信息技术有限公司")
    private String companyName;

    @ApiModelProperty(value = "税号", dataType = "String", name = "taxNo", example = "934536612414UX")
    private String taxNo;

    @ApiModelProperty(value = "合同模板编号", dataType = "String", name = "contractTemplateCode", example = "PYT0501")
    private String contractTemplateCode;

    @ApiModelProperty(value = "合同模板id", dataType = "String", name = "templateId", example = "123456")
    private String templateId;

    @ApiModelProperty(value = "合同标题", dataType = "String", name = "contractTitle", example = "XX投资合同")
    private String contractTitle;

    @ApiModelProperty(value = "字体类型 0-宋体 1-仿宋 2-黑体 3-楷体 4-微软雅黑", dataType = "String", name = "fontType", example = "0")
    private String fontType;

    @ApiModelProperty(value = "字体大小，参考word字体设置，例如：10,12.5,14", dataType = "String", name = "fontSize", example = "10")
    private String fontSize;

    @ApiModelProperty(value = "合同参数", dataType = "String", name = "parameterMap")
    private Map<String, Object> parameterMap;

    @ApiModelProperty(value = "动态表格", dataType = "List", name = "dynamicTables")
    private List<String> dynamicTables;
}
