package com.xforceplus.tower.econtract.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ContractCreationResult extends ContractDefaultResult {

    @ApiModelProperty(value = "合同Id", dataType = "String", name = "contractId", example = "123456")
    @NotNull(message = "合同Id不能为空")
    private String contractId;

    public ContractCreationResult(String contractId, String donwloadUrl, String viewUrl) {
        super(donwloadUrl, viewUrl);
        this.contractId = contractId;
    }
}
