package com.xforceplus.tower.econtract.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ContractSignReq  implements Serializable {

    @ApiModelProperty(value = "签署公司列表", dataType = "List", name = "companyNames", example = "[companyName1,companyName2,companyName3]")
    private List<String> companyNames;

    @ApiModelProperty(value = "签署公司列表", dataType = "List", name = "companyNames", example = "[companyName1,companyName2,companyName3]")
    private List<String> taxNo;

    @ApiModelProperty(value = "合同模板编号", dataType = "String", name = "contractCode", example = "PYT20200501001")
    private String contractCode;

    @ApiModelProperty(value = "签署人", dataType = "String", name = "signedBy", example = "张三")
    private String signedBy;


}
