package com.xforceplus.tower.econtract.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class SealUploadRequest implements Serializable {

    @ApiModelProperty(value = "基于base64编码的电子签章图片（当sealImageBase64非空时，sealBody必须为空）", dataType = "String", name = "sealImageBase64", example = "123456")
    private String sealImageBase64;

    @ApiModelProperty(value = "签章文字内容（当sealBody非空时，sealImageBase64必须为空）", dataType = "String", name = "sealBody", example = "XXX公司")
    private String sealBody;

}
