package com.xforceplus.tower.econtract.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class SealUploadResult implements Serializable {

    @ApiModelProperty(value = "电子签章id（当上传电子签章图片时，此项为空）", dataType = "String", name = "sealId", example = "123456")
    @JsonAlias({"signature_id"})
    private String sealId;

    @ApiModelProperty(value = "签章扩展信息（未使用）", dataType = "String", name = "sealInfo", example = "XXX公司")
    @JsonAlias({"signature_sub_info"})
    private String sealInfo;

    @ApiModelProperty(value = "基于base64编码的电子签章图片（当上传电子签章文字时，此项非空）", dataType = "String", name = "sealImageBase64", example = "123456")
    @JsonAlias({"signature_img_base64"})
    private String sealImageBase64;

    @ApiModelProperty(value = "扩展信息（未使用）", dataType = "String", name = "status", example = "1")
    private String status;
}
