package com.xforceplus.tower.econtract.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class TenantConfigRequest implements Serializable {

    @ApiModelProperty(value = "电子合同提供商（0=默认由系统指定 1=法大大）", dataType = "int", name = "contractProvider", example = "0")
    @NotNull(message = "电子合同提供商不能为空")
    private int contractProvider;

    @ApiModelProperty(value = "电子合同提供商的密钥id", dataType = "Long", name = "contractSecretId", example = "0")
    @NotNull(message = "电子合同密钥id不能为空")
    private Long contractSecretId;

    @ApiModelProperty(value = "电子签章提供商（0=默认由系统指定 1=法大大）", dataType = "int", name = "sealProvider", example = "0")
    @NotNull(message = "电子签章提供商不能为空")
    private int sealProvider;

    @ApiModelProperty(value = "电子签章提供商的密钥id", dataType = "Long", name = "sealSecretId", example = "0")
    @NotNull(message = "电子签章密钥id不能为空")
    private Long sealSecretId;

    @ApiModelProperty(value = "配置状态（0=禁用 1=启用）", dataType = "int", name = "status", example = "1")
    @NotNull(message = "配置状态不能为空")
    private int status;

}
