package com.xforceplus.tower.econtract.model.impl;

import com.xforceplus.tower.econtract.model.interfaces.ContractSignParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class ContractSignParamFadadaImpl implements ContractSignParam {

    @ApiModelProperty(value = "接入方角色（1-接入平台）", dataType = "String", name = "clientRole", example = "1")
    private String clientRole;

    @ApiModelProperty(value = "定位类型 0-关键字（默认）1-坐标", dataType = "String", name = "positionType", example = "0")
    private String positionType;

    @ApiModelProperty(value = "定位关键字,关键字为文档中的文字内容（能被 ctrl+f 查找功能检索到）。法大大按此关键字进行签章位置的定位，" +
            "将电子章盖在这个关键字上面。凡出现关键字的地方均会盖上指定用户的电子章，建议关键字在合同中保持唯一。当 positionType为0时，此参数必填", dataType = "String", name = "signKeyword", example = "XXXX公司")
    private String signKeyword;

    @ApiModelProperty(value = "关键字签章策略（0：所有关键字签章（默认）；1：第一个关键字签章；2：最后一个关键字签章）", dataType = "String", name = "keywordStrategy", example = "0")
    private String keywordStrategy;

    @ApiModelProperty(value = "定位坐标, 当positionType为1时，此参数必填", dataType = "List", name = "signaturePositions", example = "[]")
    private List<SearchLocation> signaturePositions;

    @ApiModelProperty(value = "页面跳转URL（签署结果同步通知），当签章完成后，在签章页面停留数秒后，浏览器会自动跳转到此URL，内容由接入平台自行展示； 参见《页面跳转规范（return_url）》", dataType = "String", name = "returnUrl", example = "")
    private String returnUrl;

    @ApiModelProperty(value = "签署结果异步通知URL;如果指定，当签章完成后，法大大将向此URL发送签署结果。 参见《签署结果异步通知规范（notify_url）》", dataType = "String", name = "notifyUrl", example = "")
    private String notifyUrl;

    public class SearchLocation {

        @ApiModelProperty(value = "签章页码，从 0 开始。即在第一页签章，传0", dataType = "int", name = "pageNum", example = "0")
        private int pageNum;

        @ApiModelProperty(value = "盖章点x坐标，以左上角为原点0,0，取鼠标位置为图片中心点。坐标请以图片宽度为800为基准", dataType = "double", name = "x", example = "0.00")
        private double x;

        @ApiModelProperty(value = "盖章点y坐标，以左上角为原点0,0，取鼠标位置为图片中心点。坐标请以图片高度为1131为基准", dataType = "double", name = "y", example = "0.00")
        private double y;
    }

}