package com.xforceplus.tower.econtract.model.impl;

import com.xforceplus.tower.econtract.model.interfaces.DynamicTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class DynamicTableFadadaImpl implements DynamicTable {

    @ApiModelProperty(value = "动态表格插入方式（0-新建页面添加table（默认）1-在某个关键字后添加table）", dataType = "Integer", name = "insertWay")
    public Integer insertWay;

    @ApiModelProperty(value = "关键字方式插入动态表格（当insertWay为1时，必填；要求该关键字后（当前页）必须不包含内容，否则会被覆盖；" +
            "若关键字为多个，则取第一个关键字，在此关键字后插入table", dataType = "String", name = "Keyword")
    public String Keyword;

    @ApiModelProperty(value = "表格需要插入的页数（当insertWay为0时，必填；表示从第几页开始插入表格，如要从末尾插入table，则pageBegin为pdf总页数加1；" +
            "多个表格指定相同pageBegin，则多个表格按顺序插入，一个表格新起一页；pageBegin为-1时，则从pdf末尾插入table", dataType = "Integer", name = "pageBegin")
    public Integer pageBegin;

    @ApiModelProperty(value = "table是否有边框（true：有（默认）false：无边框）", dataType = "Boolean", name = "borderFlag")
    public Boolean borderFlag;

    @ApiModelProperty(value = "正文行高（表头不受影响）单位：pt，即 point，等于1/72英寸", dataType = "Float", name = "cellHeight")
    public Float cellHeight;

    @ApiModelProperty(value = "Table中每个单元的水平对齐方式（0：居左；1：居中；2：居右）默认为0", dataType = "Integer", name = "cellHorizontalAlignment")
    public Integer cellHorizontalAlignment;

    @ApiModelProperty(value = "Table中每个单元的垂直对齐方式（4：居上；5：居中；6：居下）默认为4", dataType = "Integer", name = "cellVerticalAlignment")
    public Integer cellVerticalAlignment;

    @ApiModelProperty(value = "表头上方的一级标题", dataType = "String", name = "theFirstHeader")
    public String theFirstHeader;

    @ApiModelProperty(value = "表头信息", dataType = "String[]", name = "headers")
    public String[] headers;

    @ApiModelProperty(value = "表头对齐方式（0 居左;1 居中;2 居右）默认0", dataType = "Integer", name = "headerAlignment")
    public Integer headersAlignment;

    @ApiModelProperty(value = "数据行（外层表示行，内层表示列）", dataType = "String[][]", name = "data")
    public String[][] datas;

    @ApiModelProperty(value = "各列宽度比例；默认值：各列1:1", dataType = "Integer[]", name = "colWidthPercent")
    public Integer[] colWidthPercent;

    @ApiModelProperty(value = "Table的水平对齐方式（0 居左，1 居中，2 居右）默认1", dataType = "Integer", name = "tableHorizontalAlignment")
    public Integer tableHorizontalAlignment;

    @ApiModelProperty(value = "宽度的百分比 （0<tableWidthPercentage<=100）默认 为 100.0", dataType = "Float", name = "tableWidthPercentage")
    public Float tableWidthPercentage;

    @ApiModelProperty(value = "设置table居左、居中、居右后的水平偏移量（向右偏移值为正数，向左偏移值为负数）默认为0.0，单位px（像素）", dataType = "Float", name = "tableHorizontalOffset")
    public Float tableHorizontalOffset;

}
