package com.xforceplus.tower.econtract.api;

import com.xforceplus.tower.econtract.model.ContractTemplateRequest;
import com.xforceplus.tower.econtract.model.ContractTemplateUpdateReq;
import com.xforceplus.tower.econtract.model.DefaultResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

import static org.springframework.http.MediaType.APPLICATION_JSON_VALUE;

//import static org.springframework.http.MediaType.APPLICATION_JSON_UTF8_VALUE;

/**
 * @author lixuekun
 */
@RequestMapping("/{tenantId}/enterprise/v1/econtract")
@Api(tags = "合同模板")
public interface ContractTemplateApi {

    @RequestMapping(value = "/templates/file", method = RequestMethod.PUT )
    @ApiOperation(value = "上传合同模板")
    DefaultResponse uploadTemplate(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = false) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "合同模板编号", required = true) @RequestParam("contractTemplateCode") String contractTemplateCode,
            @ApiParam(value = "合同模板文件", required = true) @RequestParam("multipartFile") MultipartFile multipartFile
            );


    @RequestMapping(value = "/template", method = RequestMethod.POST )
    @ApiOperation(value = "新建合同模板")
    DefaultResponse addContractTemplate(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = false) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "合同模板", required = true) @RequestBody ContractTemplateRequest templateRequest
    );

    @RequestMapping(value = "/templates", method = RequestMethod.GET )
    @ApiOperation(value = "查询合同模板")
    DefaultResponse retrieveContractTemplate(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = false) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "合同模板名称", required = false) @RequestParam("contractName") String contractName,
            @ApiParam(value = "合同模板编号", required = false) @RequestParam("contractTemplateCode") String contractTemplateCode,
            @RequestParam(value = "pageNo", required = false) @Min(1) Integer page,
            @RequestParam(value = "pageSize", required = false) @Min(1) @Max(200) Integer size

    );

    @RequestMapping(value = "/templates", method = RequestMethod.PUT )
    @ApiOperation(value = "更新合同模板")
    DefaultResponse updateContractTemplate(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = false) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "合同模板编号", required = true) @RequestParam("contractTemplateCode") String contractTemplateCode,
            @ApiParam(value = "合同模板", required = true) @RequestBody ContractTemplateUpdateReq templateRequest
    );

    @RequestMapping(value = "/templates", method = RequestMethod.DELETE )
    @ApiOperation(value = "删除合同模板")
    DefaultResponse deleteContractTemplate(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = false) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "合同模板编号", required = true) @RequestParam("contractTemplateCode") String contractTemplateCode
    );
}
