package com.xforceplus.tower.econtract.api;

import com.xforceplus.tower.econtract.model.DefaultResponse;
import com.xforceplus.tower.econtract.model.SealUploadRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

import static org.springframework.http.MediaType.APPLICATION_JSON_UTF8_VALUE;

@RequestMapping("/{tenantId}/enterprise/v1/econtract")
@Api(tags = "electronic seal")
public interface SealApi {

    @RequestMapping(value = "/seals", method = RequestMethod.POST, produces = APPLICATION_JSON_UTF8_VALUE, consumes = APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "上传签章文字或图片")
    DefaultResponse uploadSeal(
            @ApiParam(value = "租户id", required = true) @PathVariable("tenantId") Long tenantId,
            @ApiParam(value = "应用id", required = true) @RequestParam("appId") Long appId,
            @ApiParam(value = "公司id", required = true) @RequestParam("companyId") Long companyId,
            @ApiParam(value = "签章上传请求", required = true) @RequestBody @Valid SealUploadRequest sealUploadRequest);

}
