package com.xforceplus.tower.econtract.constant;

public enum ProviderEnum {

    UNIMPLEMENTED(-99, "unimplemented", "com.xforceplus.tower.econtract.factory.impl.UnimplementedClientFactory",
            "com.xforceplus.tower.econtract.factory.impl.UnimplementedClientFactory"),
    DUMMY(-1, "dummy", "com.xforceplus.tower.econtract.factory.impl.DummyClientFactory",
            "com.xforceplus.tower.econtract.factory.impl.DummyClientFactory"),
    FADADA(1, "fadada", "com.xforceplus.tower.econtract.factory.impl.FadadaClientFactory",
            "com.xforceplus.tower.econtract.factory.impl.FadadaClientFactory"),
    ESIGN(2, "esign", "com.xforceplus.tower.econtract.factory.impl.ESignClientFactory",
                   "com.xforceplus.tower.econtract.factory.impl.ESignClientFactory");

    private int id;
    private String name;
    private String contractFactory;
    private String sealFactory;

    ProviderEnum(int id, String name, String contractFactory, String sealFacotry) {
        this.id = id;
        this.name = name;
        this.contractFactory = contractFactory;
        this.sealFactory = sealFacotry;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getContractFactory() {
        return contractFactory;
    }

    public String getSealFactory() {
        return sealFactory;
    }

    public static ProviderEnum nameOf(String name) {
        for (ProviderEnum providerEnum : ProviderEnum.values()) {
            if (name.equals(providerEnum.getName())) {
                return providerEnum;
            }
        }
        return null;
    }

    public static ProviderEnum idOf(int id) {
        for (ProviderEnum providerEnum : ProviderEnum.values()) {
            if (providerEnum.getId() == id) {
                return providerEnum;
            }
        }
        return null;
    }

    /**
     * if id == 0, create it with default provider anme
     *
     * @param id
     * @param defaultProviderName
     * @return
     */
    public static ProviderEnum idOf(int id, String defaultProviderName) {
        ProviderEnum providerEnum = null;
        if (id == 0) {
            providerEnum = ProviderEnum.nameOf(defaultProviderName);
        } else {
            providerEnum = ProviderEnum.idOf(id);
        }
        return providerEnum;
    }
}
