package com.xforceplus.tower.econtract.constant;

public enum ResponseCodeEnum {

    SUCCESS("ELCCZZ0200", "请求成功"),
    PARAM_ERROR("ELCCZZ0400", "请求参数错误"),
    INVALID_USER("ELCCZZ0401", "非法用户"),
    FORBIDDEN_REQUEST("ELCCZZ0403", "超过限流的最大值，访问被拒绝"),
    SERVER_ERROR("ELCCZZ0500", "服务器出现异常"),
    INVOCATION_TIMEOUT("ELCCZZ1001", "第三方调用超时"),
    INVOCATION_ERROR("ELCCZZ1002", "第三方调用异常");

    private String code;

    private String message;

    ResponseCodeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
