package com.xforceplus.tower.econtract.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ContractDefaultResult implements Serializable {

    public ContractDefaultResult(String downloadUrl, String viewUrl){
        this.downloadUrl = downloadUrl;
        this.internalUrl = viewUrl;
    }

    private Long id;
    private String contractTemplateCode;
    private String contractCode;
    private String contractName;
    private String companyName;
    private String taxNo;
    private Integer signStatus;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date signDate;
    private String signedBy;
    private String signInfo;
    private Long contractFileId;
    private String contractFileUrl;
    private Long createUserId;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    private Long updateUserId;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    private Long appId;
    private Long tenantId;


    @ApiModelProperty(value = "合同下载地址，填充失败时为空", dataType = "String", name = "downloadUrl", example = "123456")
    @JsonAlias({"download_url"})
    private String downloadUrl;

    @ApiModelProperty(value = "合同查看地址，填充失败时为空", dataType = "String", name = "viewUrl", example = "123456")
    @JsonAlias({"viewpdf_url"})
    private String internalUrl;
}
