package com.xforceplus.tower.econtract.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ContractSignRequest implements Serializable {

    @ApiModelProperty(value = "公司名称", dataType = "String", name = "companyName")
    private String companyName;

    @ApiModelProperty(value = "公司税号", dataType = "String", name = "taxNo")
    private String taxNo;

    @ApiModelProperty(value = "合同模板Code", dataType = "String", name = "contractTemplateCode")
    private String contractTemplateCode;

    @ApiModelProperty(value = "合同名称", dataType = "String", name = "contractName", example = "电票协议")
    private String contractName;

    @ApiModelProperty(value = "合同编号", dataType = "String", name = "contractCode", example = "PTY0520001")
    private String contractCode;

    @ApiModelProperty(value = "签署人", dataType = "String", name = "signedBy")
    private String signedBy;

    @ApiModelProperty(value = "自动签署可选参数", dataType = "Map", name = "parameters")
    private Map<String, Object> parameters;

    @ApiModelProperty(value = "自动签署事务id", dataType = "String", name = "transactionId", example = "123456")
    private String transactionId;

    @ApiModelProperty(value = "签章id，通过上传签章图片返回，注意上传签章文字不返回签章id）", dataType = "String", name = "transactionId", example = "123456")
    private String sealId;

    @ApiModelProperty(value = "合同标题", dataType = "String", name = "contractTitle", example = "XX投资合同")
    private String contractTitle;

    @ApiModelProperty(value = "签署（默认为1：签署， 0：仅填充）", dataType = "Integer", name = "signStatus", example = "1")
    private Integer signStatus;

}
