package com.xforceplus.tower.econtract.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ContractSignResult implements Serializable {

    @ApiModelProperty(value = "签署公司", dataType = "String", name = "companyName", example = "上海万科信息技术有限公司")
    @JsonAlias({"company_name"})
    private String companyName;

    @ApiModelProperty(value = "合同下载地址，填充失败时为空", dataType = "String", name = "contractUrl",
            example = "http://standard-file-transfer-fat.oss-cn-hangzhou.aliyuncs.com//test/contract/Signed_Organize_tops.pdf")
    @JsonAlias({"contract_url"})
    private String contractUrl;

    @ApiModelProperty(value = "签署状态", dataType = "Integer", name = "signStatus", example = "1")
    private Integer signStatus;

    @ApiModelProperty(value = "签署日期", dataType = "Date", name = "signDate", example = "1970-01-01 12:00:00")
    private Date signDate;

    @ApiModelProperty(value = "签署人", dataType = "String", name = "signedBy", example = "张三")
    private String signedBy;


}
