package com.xforceplus.tower.econtract.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * ContractTemplateRequest
 *
 * @author lixuekun
 * @date 2020/5/18 19:50
 **/
@Data
public class ContractTemplateUpdateReq implements Serializable {

    @NotNull(message = "合同模板名称不能为空")
    @ApiModelProperty(value = "合同模板名称", dataType = "String", name = "contractName")
    private String contractName;

    @ApiModelProperty(value = "合同模板描述", dataType = "String", name = "contractDescription")
    private String contractDescription;

    @ApiModelProperty(value = "模板内容参数(JSON 格式)", dataType = "String", name = "contentParam")
    private Map<String, Object> contentParam;

    @ApiModelProperty(value = "模板签章参数(JSON 格式)", dataType = "String", name = "contentSignParam")
    private Map<String, Object> contentSignParam;

}
