/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.econtract.api;

import com.xforceplus.tower.econtract.model.ContractCreationRequest;
import com.xforceplus.tower.econtract.model.ContractSignRequest;
import com.xforceplus.tower.econtract.model.DefaultResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/{tenantId}/enterprise/v1/econtract"})
@Api(tags={"electronic contract"})
public interface ContractApi {
    @RequestMapping(value={"/contracts/templates"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u4e0a\u4f20\u5408\u540c\u6a21\u677f")
    public DefaultResponse uploadTemplate(@ApiParam(value="\u79df\u6237id", required=true) @PathVariable(value="tenantId") Long var1, @ApiParam(value="\u5e94\u7528id", required=true) @RequestParam(value="appId") Long var2, @ApiParam(value="\u516c\u53f8id", required=false) @RequestParam(value="companyId") Long var3, @ApiParam(value="\u5408\u540c\u6a21\u677f\u6587\u4ef6", required=true) @RequestParam(value="multipartFile") MultipartFile var4);

    @RequestMapping(value={"/contracts"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u521b\u5efa\u5408\u540c")
    public DefaultResponse createContract(@ApiParam(value="\u79df\u6237id", required=true) @PathVariable(value="tenantId") Long var1, @ApiParam(value="\u5e94\u7528id", required=true) @RequestParam(value="appId") Long var2, @ApiParam(value="\u516c\u53f8id", required=false) @RequestParam(value="companyId") Long var3, @ApiParam(value="\u521b\u5efa\u5408\u540c\u8bf7\u6c42", required=true) @RequestBody @Valid ContractCreationRequest var4);

    @RequestMapping(value={"/contracts/{contractId}/signature"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u7b7e\u7f72\u5408\u540c")
    public DefaultResponse signContract(@ApiParam(value="\u79df\u6237id", required=true) @PathVariable(value="tenantId") Long var1, @ApiParam(value="\u5408\u540cid", required=true) @PathVariable(value="contractId") String var2, @ApiParam(value="\u5e94\u7528id", required=true) @RequestParam(value="appId") Long var3, @ApiParam(value="\u516c\u53f8id", required=true) @RequestParam(value="companyId") Long var4, @ApiParam(value="\u662f\u5426\u81ea\u52a8\u7b7e\u7f72", required=true) @RequestParam(value="auto") Boolean var5, @ApiParam(value="\u7b7e\u7f72\u5408\u540c\u8bf7\u6c42", required=true) @RequestBody @Valid ContractSignRequest var6);

    @RequestMapping(value={"/contracts/{contractId}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u83b7\u53d6\u5408\u540c")
    public DefaultResponse obtainContract(@ApiParam(value="\u79df\u6237id", required=true) @PathVariable(value="tenantId") Long var1, @ApiParam(value="\u5408\u540cid", required=true) @PathVariable(value="contractId") String var2, @ApiParam(value="\u5e94\u7528id", required=true) @RequestParam(value="appId") Long var3, @ApiParam(value="\u516c\u53f8id", required=true) @RequestParam(value="companyId") Long var4, @ApiParam(value="\u662f\u5426\u9700\u8981\u4e0b\u8f7d", required=true) @RequestParam(value="download") Boolean var5);

    @RequestMapping(value={"/contracts"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u67e5\u8be2\u7b7e\u7f72\u5408\u540c")
    public DefaultResponse fetchContract(@ApiParam(value="\u79df\u6237id", required=true) @PathVariable(value="tenantId") Long var1, @ApiParam(value="\u5e94\u7528id", required=true) @RequestParam(value="appId") Long var2, @ApiParam(value="\u516c\u53f8\u7a0e\u53f7", required=true) @RequestParam(value="taxNo") List<String> var3, @ApiParam(value="\u5408\u540c\u72b6\u6001\uff080:\u672a\u7b7e\u7f72,1:\u5df2\u7b7e\u7f72\uff09", required=false) @RequestParam(value="signStatus", required=false) Integer var4, @RequestParam(value="pageNo", required=false) @Min(value=1L) @Min(value=1L) Integer var5, @RequestParam(value="pageSize", required=false) @Min(value=1L) @Max(value=200L) @Min(value=1L) @Max(value=200L) Integer var6);

    @RequestMapping(value={"/contracts/signature"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u7b7e\u7f72\u5408\u540c")
    public DefaultResponse signedContract(@ApiParam(value="\u79df\u6237id", required=true) @PathVariable(value="tenantId") Long var1, @ApiParam(value="\u5e94\u7528id", required=true) @RequestParam(value="appId") Long var2, @ApiParam(value="\u516c\u53f8id", required=false) @RequestParam(value="companyId") Long var3, @ApiParam(value="\u7b7e\u7f72\u5408\u540c\u8bf7\u6c42", required=true) @RequestBody @Valid ContractSignRequest var4);

    @RequestMapping(value={"/contracts/import"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u4e0a\u4f20\u5f85\u7b7e\u7f72\u5408\u540c")
    public DefaultResponse importContract(@ApiParam(value="\u79df\u6237id", required=true) @PathVariable(value="tenantId") Long var1, @ApiParam(value="\u5e94\u7528id", required=true) @RequestParam(value="appId") Long var2, @ApiParam(value="\u516c\u53f8id", required=false) @RequestParam(value="companyId") Long var3, @ApiParam(value="\u5408\u540c\u6a21\u677fCode", required=true) @RequestParam(value="contractTemplateCode") String var4, @RequestParam(value="\u4e0a\u4f20\u6587\u4ef6", required=true) MultipartFile var5);

    @RequestMapping(value={"/management/contracts"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u67e5\u8be2\u5408\u540c\u7b7e\u7f72\u7ed3\u679c")
    public DefaultResponse queryContract(@ApiParam(value="\u79df\u6237id", required=true) @PathVariable(value="tenantId") Long var1, @ApiParam(value="\u5e94\u7528id", required=true) @RequestParam(value="appId") Long var2, @ApiParam(value="\u516c\u53f8\u540d\u79f0", required=false) @RequestParam(value="companyName") String var3, @ApiParam(value="\u516c\u53f8\u7a0e\u53f7", required=false) @RequestParam(value="taxNo") String var4, @ApiParam(value="\u5408\u540c\u6a21\u677fCode", required=false) @RequestParam(value="contractTemplateCode") String var5, @ApiParam(value="\u5408\u540c\u72b6\u6001\uff080:\u672a\u7b7e\u7f72,1:\u5df2\u7b7e\u7f72\uff09", required=false) @RequestParam(value="signStatus", required=false) Integer var6, @RequestParam(value="pageNo", required=false) @Min(value=1L) @Min(value=1L) Integer var7, @RequestParam(value="pageSize", required=false) @Min(value=1L) @Max(value=200L) @Min(value=1L) @Max(value=200L) Integer var8);

    @RequestMapping(value={"/management/contracts/status"}, method={RequestMethod.PUT}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u66f4\u6539\u7b7e\u7f72\u72b6\u6001")
    public DefaultResponse updateContractStatus(@ApiParam(value="\u79df\u6237id", required=true) @PathVariable(value="tenantId") Long var1, @ApiParam(value="\u5e94\u7528id", required=true) @RequestParam(value="appId") Long var2, @ApiParam(value="\u516c\u53f8\u7a0e\u53f7", required=true) @RequestParam(value="taxNo") List<String> var3, @ApiParam(value="\u5408\u540c\u6a21\u677fCode", required=true) @RequestParam(value="contractTemplateCode") String var4, @ApiParam(value="\u5408\u540c\u72b6\u6001\uff080:\u672a\u7b7e\u7f72,1:\u5df2\u7b7e\u7f72, 2:\u65e0\u9700\u7b7e\u7f72\uff09", required=true) @RequestParam(value="signStatus", required=true) Integer var5);
}

