/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.econtract.constant;

public enum ProviderEnum {
    UNIMPLEMENTED(-99, "unimplemented", "com.xforceplus.tower.econtract.factory.impl.UnimplementedClientFactory", "com.xforceplus.tower.econtract.factory.impl.UnimplementedClientFactory"),
    DUMMY(-1, "dummy", "com.xforceplus.tower.econtract.factory.impl.DummyClientFactory", "com.xforceplus.tower.econtract.factory.impl.DummyClientFactory"),
    FADADA(1, "fadada", "com.xforceplus.tower.econtract.factory.impl.FadadaClientFactory", "com.xforceplus.tower.econtract.factory.impl.FadadaClientFactory"),
    ESIGN(2, "esign", "com.xforceplus.tower.econtract.factory.impl.ESignClientFactory", "com.xforceplus.tower.econtract.factory.impl.ESignClientFactory");

    private int id;
    private String name;
    private String contractFactory;
    private String sealFactory;

    private ProviderEnum(int id, String name, String contractFactory, String sealFacotry) {
        this.id = id;
        this.name = name;
        this.contractFactory = contractFactory;
        this.sealFactory = sealFacotry;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getContractFactory() {
        return this.contractFactory;
    }

    public String getSealFactory() {
        return this.sealFactory;
    }

    public static ProviderEnum nameOf(String name) {
        for (ProviderEnum providerEnum : ProviderEnum.values()) {
            if (!name.equals(providerEnum.getName())) continue;
            return providerEnum;
        }
        return null;
    }

    public static ProviderEnum idOf(int id) {
        for (ProviderEnum providerEnum : ProviderEnum.values()) {
            if (providerEnum.getId() != id) continue;
            return providerEnum;
        }
        return null;
    }

    public static ProviderEnum idOf(int id, String defaultProviderName) {
        ProviderEnum providerEnum = null;
        providerEnum = id == 0 ? ProviderEnum.nameOf(defaultProviderName) : ProviderEnum.idOf(id);
        return providerEnum;
    }
}

