package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 借阅状态
 * </p>
 *
 * @author ultraman
 * @since 2021-01-14
 */
public enum BorrowStatus {

    _0("0", "未借阅"),
    _1("1", "部分借阅"),
    _2("2", "全部借阅");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BorrowStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
