package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票联次,票联次
 * </p>
 *
 * @author ultraman
 * @since 2021-01-14
 */
public enum InvoiceSheet {

    _1("1", "发票联"),
    _2("2", "抵扣联"),
    _3("3", "存根联"),
    _4("4", "记账联"),
    _5("5", "第五联"),
    _6("6", "第六联"),
    _0("0", "未定义");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceSheet(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
