package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 保密等级
 * </p>
 *
 * @author ultraman
 * @since 2021-01-14
 */
public enum SecurityLevel {

    _1("1", "机密"),
    _2("2", "秘密"),
    _3("3", "内部"),
    _4("4", "国内"),
    _5("5", "公开");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SecurityLevel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
