package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 保管状态
 * </p>
 *
 * @author ultraman
 * @since 2021-01-14
 */
public enum StoragePeriodStatus {

    _0("0", "未到期"),
    _1("1", "即将到期"),
    _2("2", "已过期");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StoragePeriodStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
