package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 入库状态
 * </p>
 *
 * @author ultraman
 * @since 2021-01-14
 */
public enum VolumeStorageStatus {

    _0("0", "未入库"),
    _1("1", "待入库"),
    _2("2", "已入库");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VolumeStorageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
