package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 样式小类
 * </p>
 *
 * @author ultraman
 * @since 2021-01-29
 */
public enum StyleSmallType {

    COVER_A001("coverA001", "记账凭证"),
    COVER_A002("coverA002", "付款凭证"),
    COVER_A003("coverA003", "收款凭证"),
    COVER_A004("coverA004", "转账凭证"),
    COVER_A005("coverA005", "通用记账凭证"),
    COVER_B001("coverB001", "凭证封面"),
    COVER_B002("coverB002", "会计账簿"),
    COVER_B003("coverB003", "会计报告");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StyleSmallType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StyleSmallType fromCode(String code){
        switch(code) {
            case "coverA001":
                return COVER_A001;
            case "coverA002":
                return COVER_A002;
            case "coverA003":
                return COVER_A003;
            case "coverA004":
                return COVER_A004;
            case "coverA005":
                return COVER_A005;
            case "coverB001":
                return COVER_B001;
            case "coverB002":
                return COVER_B002;
            case "coverB003":
                return COVER_B003;
            default:
                return null;
        }
    }
}
