package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-01-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BaseVoucher implements Serializable {

  private static final long serialVersionUID=1L;

  private String voucherNo;

  private Long companyId;

  private String companyCode;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String companyName;

  private String companyTaxNo;

  private String exceptionDesc;

  private Long imageCount;

  private Long volumeId;

  private String origSystem;

  private String sensitiveFlag;

  private String virtualFlag;

  private String indexStatus;

  private String status;

  private String exceptionFlag;

  private String warningFlag;

  private String borrowStatus;

  private String materialStatus;

  private String materialSituation;

  private String type;

  private String imgUrl;

  private Long orgId;

  private String sensitiveSituation;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("voucher_no", voucherNo);
      map.put("company_id", companyId);
      map.put("company_code", companyCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("exception_desc", exceptionDesc);
      map.put("image_count", imageCount);
      map.put("volume_id", volumeId);
      map.put("orig_system", origSystem);
      map.put("sensitive_flag", sensitiveFlag);
      map.put("virtual_flag", virtualFlag);
      map.put("index_status", indexStatus);
      map.put("status", status);
      map.put("exception_flag", exceptionFlag);
      map.put("warning_flag", warningFlag);
      map.put("borrow_status", borrowStatus);
      map.put("material_status", materialStatus);
      map.put("material_situation", materialSituation);
      map.put("type", type);
      map.put("img_url", imgUrl);
      map.put("org_id", orgId);
      map.put("sensitive_situation", sensitiveSituation);
      return map;
  }

  public static BaseVoucher fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    BaseVoucher entity = new BaseVoucher();
    if(map.containsKey("voucher_no")) {
      Object obj = map.get("voucher_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_desc")) {
      Object obj = map.get("exception_desc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("image_count")) {
      Object obj = map.get("image_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageCount(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("volume_id")) {
      Object obj = map.get("volume_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setVolumeId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("orig_system")) {
      Object obj = map.get("orig_system");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_flag")) {
      Object obj = map.get("sensitive_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtual_flag")) {
      Object obj = map.get("virtual_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVirtualFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("index_status")) {
      Object obj = map.get("index_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIndexStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_flag")) {
      Object obj = map.get("warning_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_status")) {
      Object obj = map.get("borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_status")) {
      Object obj = map.get("material_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_situation")) {
      Object obj = map.get("sensitive_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveSituation((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
