package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 会记类别
 * </p>
 *
 * @author ultraman
 * @since 2021-02-05
 */
public enum AccountType {

    A001("A001", "会记凭证"),
    A002("A002", "会记账簿"),
    A003("A003", "会记报表"),
    A004("A004", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AccountType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountType fromCode(String code){
        switch(code) {
            case "A001":
                return A001;
            case "A002":
                return A002;
            case "A003":
                return A003;
            case "A004":
                return A004;
            default:
                return null;
        }
    }
}
