package com.xforceplus.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 样式大类
 * </p>
 *
 * @author ultraman
 * @since 2021-02-05
 */
public enum StyleLargeType {

    COVER_A("coverA", "记账凭证"),
    COVER_B("coverB", "凭证封面"),
    COVER_C("coverC", "立卷清单"),
    COVER_D("coverD", "装盒清单"),
    COVER_E("coverE", "移交清册");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StyleLargeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StyleLargeType fromCode(String code){
        switch(code) {
            case "coverA":
                return COVER_A;
            case "coverB":
                return COVER_B;
            case "coverC":
                return COVER_C;
            case "coverD":
                return COVER_D;
            case "coverE":
                return COVER_E;
            default:
                return null;
        }
    }
}
