package com.xforceplus.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-03-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Volume implements Serializable {

  private static final long serialVersionUID=1L;

  private Long orgId;

  private Long companyId;

  private String companyCode;

  private String businessType;

  private String volumeNo;

  private Long volumeCount;

  private Long volumeOrder;

  private String status;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingPeriod;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;

  private String voucherMinNo;

  private String voucherMaxNo;

  private String volumeUsername;

  private Long boxId;

  private Long locationId;

  private Long warehouseId;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String companyName;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime volumeTime;

  private String materialSituation;

  private String exceptionFlag;

  private String exceptionDes;

  private String sensitiveSituation;

  private String borrowSituation;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("org_id", orgId);
      map.put("company_id", companyId);
      map.put("company_code", companyCode);
      map.put("business_type", businessType);
      map.put("volume_no", volumeNo);
      map.put("volume_count", volumeCount);
      map.put("volume_order", volumeOrder);
      map.put("status", status);
      map.put("accounting_period", BocpGenUtils.toTimestamp(accountingPeriod));
      map.put("start_date", BocpGenUtils.toTimestamp(startDate));
      map.put("end_date", BocpGenUtils.toTimestamp(endDate));
      map.put("voucher_min_no", voucherMinNo);
      map.put("voucher_max_no", voucherMaxNo);
      map.put("volume_username", volumeUsername);
      map.put("box_id", boxId);
      map.put("location_id", locationId);
      map.put("warehouse_id", warehouseId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("company_name", companyName);
      map.put("volume_time", BocpGenUtils.toTimestamp(volumeTime));
      map.put("material_situation", materialSituation);
      map.put("exception_flag", exceptionFlag);
      map.put("exception_des", exceptionDes);
      map.put("sensitive_situation", sensitiveSituation);
      map.put("borrow_situation", borrowSituation);
      return map;
  }

  public static Volume fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    Volume entity = new Volume();
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_no")) {
      Object obj = map.get("volume_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_count")) {
      Object obj = map.get("volume_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setVolumeCount(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("volume_order")) {
      Object obj = map.get("volume_order");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeOrder((Long)obj);
        } else if(obj instanceof String) {
          entity.setVolumeOrder(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounting_period")) {
      Object obj = map.get("accounting_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingPeriod(null);
      }
    }
    if(map.containsKey("start_date")) {
      Object obj = map.get("start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("end_date")) {
      Object obj = map.get("end_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("voucher_min_no")) {
      Object obj = map.get("voucher_min_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherMinNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_max_no")) {
      Object obj = map.get("voucher_max_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherMaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_username")) {
      Object obj = map.get("volume_username");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeUsername((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("box_id")) {
      Object obj = map.get("box_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBoxId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBoxId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("location_id")) {
      Object obj = map.get("location_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLocationId((Long)obj);
        } else if(obj instanceof String) {
          entity.setLocationId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_id")) {
      Object obj = map.get("warehouse_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWarehouseId((Long)obj);
        } else if(obj instanceof String) {
          entity.setWarehouseId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume_time")) {
      Object obj = map.get("volume_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVolumeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVolumeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVolumeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVolumeTime(null);
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_des")) {
      Object obj = map.get("exception_des");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionDes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_situation")) {
      Object obj = map.get("sensitive_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
